//=============================================================================
// MedBox.
//=============================================================================
class Health_MedBox extends MedBox;

var int HealUpTo;

auto state Pickup
{	
	function Touch( actor Other )
	{
	local Pawn P;
			
	if ( ValidTouch(Other) && Other.IsA('PlayerPawn')) 
		{	
		P = Pawn(Other);	
		if (P.Health < HealUpTo) 
			{
			P.Health += HealingAmount;
			if (P.Health > HealUpTo)
				{
				P.Health = HealUpTo;
				}
			PlayPickupMessage(P);
			PlaySound (PickupSound,,2.5);
			Other.MakeNoise(0.2);		
			SetRespawn();
			}
		}
	}
}

defaultproperties
{
     HealUpTo=300
     HealingAmount=25
     RespawnTime=0.000000
     PlayerViewMesh=LodMesh'Botpack.MedBox'
     PickupViewMesh=LodMesh'Botpack.MedBox'
     PickupSound=Sound'Botpack.Pickups.UTHealth'
     Mesh=LodMesh'Botpack.MedBox'
     CollisionRadius=32.000000
     MultiSkins(1)=Texture'UnrealShare.Belt_fx.ShieldBelt.BlueShield'
     MultiSkins(2)=Texture'UnrealShare.Belt_fx.ShieldBelt.RedShield'
}
